﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IMaxRecentDocsStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class MaxRecentDocsDefaultStrategy : ICorrespondenceOS, IMaxRecentDocsStrategy
    {
        public MaxRecentDocsDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG                                           
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "MaxRecentDocs";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");

            return new WFRegistry(@"HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer", RegName,
                              registryKey.GetValue(RegName, 15), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class MaxRecentDocsController
    {
        public MaxRecentDocsController(MaxRecentDocs maxRecentDocs,
                                                         IMaxRecentDocsStrategy strategy)
        {
            MaxRecentDocs = maxRecentDocs;
            Strategy = strategy;
        }

        public MaxRecentDocs MaxRecentDocs { get; set; }
        public IMaxRecentDocsStrategy Strategy { get; set; }

        public void Read()
        {
            MaxRecentDocs.SetMaxRecentDocsState(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(MaxRecentDocs.GetMaxRecentDocsState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
